/*
 * RootItem.h
 *
 *  Created on: 29.10.2009
 *      Author: stefan.detter
 */

#ifndef ROOTITEM_H_
#define ROOTITEM_H_

#include "TreeItem.h"
#include "ModelData.h"

#include <QList>
#include <QVector>
#include <QSet>

#include "../../application/Reader.h"

class ReaderEntry;

class RootItem: public TreeItem, public ModelData
{
	Q_OBJECT

	typedef enum
	{
		ROOT_ROW_HEADER = 0,
		ROOT_ROW_APPLICATION,
		ROOT_ROW_APPLICATION_VERSION,
		ROOT_ROW_COMMON,
		ROOT_ROW_READER_COUNT,
		ROOT_ROW_READ,
		ROOT_ROW_SHOWN_TAG_COUNT,
		ROOT_ROW_SHOWN_UNIQUE_TAG_COUNT,
		ROOT_ROW_READ_TAG_COUNT,
		ROOT_ROW_READ_UNIQUE_TAG_COUNT,
	} ROOT_INFORMATION_ROW_INDEX;

public:
	RootItem(TreeItem* parent = 0);
	virtual ~RootItem();

public:
	virtual void		updateDynamicInfo();
	virtual void		clearTags();

public:
	virtual QList<QString> 	readerList ( ) const;
	virtual QList<QString> 	tagList ( ) const;
	virtual QList<QString> 	tagListOfReader( QString reader ) const;

	virtual Reader* getReader ( QString readerId );

	ReaderEntry*	addReader ( Reader* r );
	void			removeReader ( QString readerId );
	void			removeOfflineReader ( );

public slots:
	void tagEvent(const TagEvent& event);

	void itemAboutToBeRemoved ( TreeItem* t );

private slots:
	void update ( );


/****************************************************** Display functions */
public:
	virtual TYPE 		itemType() const;
	virtual QVariant 	data(int column, int role) const;
	virtual QVariant	information (int row, int column, int role) const;

private:
	void 				prepareInformation ( );
	void 				updateInformation ( );


private:
	QTimer* 			m_updateTimer;

	QMap<QString, ReaderEntry*>	m_readerIndex;

	QSet<QString>		m_readUniqueTags;
	QSet<QString>		m_readReaderTags;

	QSet<QString>		m_shownUniqueTags;
	QSet<QString>		m_shownReaderTags;
};

#endif /* ROOTITEM_H_ */
